clear all
clc
close all

load AALabData

X=FeaturesAct;
Y=Action;

%% Find optimal number of splits using cross-validation

for q=1:100
    B = TreeBagger(50,X,Y,'OOBPrediction','On','Method','classification','MaxNumSplits',10);
    err(q)=min(oobError(B));
end

'TreeBagger'
1-mean(err)
sqrt(var(err))


%% Find Games Correctly Predicted by Tree But Not Level-1

% Find tree prediction
ypred=predict(B,X);

% Find Level 1 Prediction
n=length(Y);
lev1=zeros(1,n);
for i=1:n
    sumrow=sum(row{i},2);
    lev1(i)=find(sumrow==max(sumrow));
end

treeright_lev1wrong=zeros(1,n);
for i=1:n
    if str2double(ypred{i})==Action(i) & lev1(i)~=Action(i)
        treeright_lev1wrong(i)=1;
    end
end
sum(treeright_lev1wrong)
ind=find(treeright_lev1wrong);


%% Print Games

m=length(ind);
for i=1:m
    h=ind(i);
    R=row{h};
    C=R';
    
    fprintf('Payoff Matrix')
    fprintf('\n') 
    formatSpec = '%3.0f,%3.0f  %3.0f,%3.0f  %3.0f,%3.0f\n %3.0f,%3.0f  %3.0f,%3.0f  %3.0f,%3.0f\n %3.0f,%3.0f  %3.0f,%3.0f  %3.0f,%3.0f\n';
    fprintf(formatSpec,R(1,1),C(1,1),R(1,2),C(1,2),R(1,3),C(1,3),R(2,1),C(2,1),R(2,2),C(2,2),R(2,3),C(2,3),R(3,1),C(3,1),R(3,2),C(3,2),R(3,3),C(3,3));
    fprintf('\n') 
    formatSpec = '%3.0f,%3.0f,%3.0f';
    sumR=sum(R,2);
    fprintf('Row sums are ')
    fprintf(formatSpec,sumR(1),sumR(2),sumR(3));
    fprintf('\n') 
    fprintf('\n') 
end
